<?php
/*--------------------------------------------------------------------------------------------------
    OnGetSellingUnitQuantityListener.php 2020-02-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Listeners;

use Gambio\Shop\Properties\Database\Services\Interfaces\PropertiesReaderServiceInterface;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Services\PropertyQuantityReadServiceInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitAvailableQuantityEventInterface;

class OnGetSellingUnitAvailableQuantityListener
{
    /**
     * @var PropertyQuantityReadServiceInterface
     */
    private $service;
    
    
    /**
     * OnGetSellingUnitQuantityListener constructor.
     *
     * @param PropertyQuantityReadServiceInterface $service
     */
    public function __construct(
        PropertyQuantityReadServiceInterface $service
    ) {
        $this->service = $service;
    }
    
    
    /**
     * @param OnGetSellingUnitAvailableQuantityEventInterface $event
     *
     * @return OnGetSellingUnitAvailableQuantityEventInterface
     */
    public function __invoke(OnGetSellingUnitAvailableQuantityEventInterface $event
    ): OnGetSellingUnitAvailableQuantityEventInterface {
        
        $quantity = $this->service->getQuantityBy($event->id(), $event->product());
        if ($quantity) {
            $event->addQuantity($quantity);
            $event->stopPropagation();
        }

        return $event;
    }
    
}